﻿/**
VERSION:		1.3
1.3		Added optional auto-cleanup when "react" exists either within _this or within the specified movieClip  (removes all custom context menus)


	USAGE
#include "functions/makeContextMenu.as"
addContextItem( "Hello Werld!?", _root, myFunct );
addContextItem( "funct2()", my_mc, myFunct2, true );		// true => separator before this item
my_mc.menu.onSelect = function(){
	// onSelect() runs upon right-click
	// You can change the contextual menu now before it displays
	// addContextItem() can also be used to replace existing items with the same label
}
var menu_obj = addContextItem( null, target_mc );								// This would add .menu to the movieClip, without adding any menu-items.  menu.onSelect can be used to detect right-clicks.


	FUNCTIONS
addContextItem()				Adds a menu item / replaces duplicate menu item with a new one
removeContextItem()			Removes one or all menu items for a movieClip


	What this is for
This function makes it a little easier to assign contextual menus to movieClips.


	Advantages:
- Easy to remove a menu item
- Easy to remove all menu items in a movieClip
- Menu items can be replaced.  	(if their menuLabels are the same)
- Don't have to type   new ContextMenu()   for every single movieClip.  (done automatically)
- Use via a shorter & more intuitive line of code


	Function Examples
addContextItem( "menuLabel", target_mc, callFunction, [seperator] );
addContextItem( "Hello Werld!?", my_mc, my_mc.myFunct );							// Adds a contextual menu item to a movieClip.
addContextItem( "Hello Werld!?", my_mc, my_mc.myFunct, true );				// Adds an item & puts a seperator above it.

removeContextItem( "menuLabel", target_mc );
removeContextItem( "funct2()", this );		// Removes a contextual menu item
removeContextItem( null, target_mc );			// Removes ALL contextual menu items in target_mc
*/



// FUNCTIONS
function addContextItem( menuLabel, target_mc, callFunction, seperator )
{
	//trace("addContextItem()");
	//trace("menuLabel: "+menuLabel);
	//trace("target_mc: "+target_mc);
	//trace("callFunction: "+callFunction);
	
	var seperator = (seperator) ? seperator : false;		// default = no seperator
	
	// Create new menu for this movieClip if neccessary
	if (target_mc.menu == undefined)
	{
		target_mc.menu = new ContextMenu();
		target_mc.menu.hideBuiltInItems();
	}//if (undefined)
	var thisMenu = target_mc.menu;
	
	// If this item already exists, delete it
	for (var i = 0; i < thisMenu.customItems.length; i++)
	{
		var readmenuLabel = thisMenu.customItems[i].caption;
		if (readmenuLabel == menuLabel){
			thisMenu.customItems.splice( i, 1);		// delete
		}// if (readmenuLabel)
	}// for...in  (thisMenu.customItems)
	
	
	// Optional auto-cleanup
	var react = _this.react || target_mc.react;
	if(react !== undefined){
		react.once().to( "unload" ).from( target_mc ).then = function(){
			removeContextItem( null, target_mc );
		}// react to unload
	}// if "react" exists
	
	
	if( !menuLabel )		return target_mc.menu;
	
	// Add a new item to this movieClip's contextual menu
	var newItem = new ContextMenuItem( menuLabel, callFunction, seperator);
	thisMenu.customItems.push( newItem );
	
	
	return target_mc.menu;
}// addContextItem()



function removeContextItem( menuLabel, target_mc )
{
	// find the specified context menu item
	var thisMenu = target_mc.menu.customItems;
	if(thisMenu)
	{// if:  menu exists
		//trace("menuLabel: "+menuLabel);
		var menuLength = thisMenu.length;
		for(var i=(menuLength-1); i>=0; i--)
		{// for: thisMenu.length
			//trace("thisMenu[i].caption: "+thisMenu[i].caption);
			if (menuLabel==null  ||  thisMenu[i].caption == menuLabel)
			{// if: no menuLabel specified  or  found an item that matches menuLabel
				// delete it
				thisMenu.splice( i, 1 );
			}// if: no menuLabel specified  or  found an item that matches menuLabel
		}// for: thisMenu.length
	}// if:  menu exists
}// removeContextItem()


